package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{JsonContentType, CsvContentType}
import scala.jdk.CollectionConverters.*
final case class CaptureContentTypeHeader(
    csvContentTypes: Optional[Iterable[CsvContentType]] = Optional.Absent,
    jsonContentTypes: Optional[Iterable[JsonContentType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader = {
    import CaptureContentTypeHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader
      .builder()
      .optionallyWith(
        csvContentTypes.map(value =>
          value.map { item =>
            CsvContentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.csvContentTypes)
      .optionallyWith(
        jsonContentTypes.map(value =>
          value.map { item =>
            JsonContentType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jsonContentTypes)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly =
    zio.aws.sagemaker.model.CaptureContentTypeHeader.wrap(buildAwsValue())
}
object CaptureContentTypeHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CaptureContentTypeHeader =
      zio.aws.sagemaker.model.CaptureContentTypeHeader(
        csvContentTypes.map(value => value),
        jsonContentTypes.map(value => value)
      )
    def csvContentTypes: Optional[List[CsvContentType]]
    def jsonContentTypes: Optional[List[JsonContentType]]
    def getCsvContentTypes: ZIO[Any, AwsError, List[CsvContentType]] =
      AwsError.unwrapOptionField("csvContentTypes", csvContentTypes)
    def getJsonContentTypes: ZIO[Any, AwsError, List[JsonContentType]] =
      AwsError.unwrapOptionField("jsonContentTypes", jsonContentTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader
  ) extends zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly {
    override val csvContentTypes: Optional[List[CsvContentType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csvContentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.CsvContentType(item)
          }.toList
        )
    override val jsonContentTypes: Optional[List[JsonContentType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jsonContentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.JsonContentType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CaptureContentTypeHeader
  ): zio.aws.sagemaker.model.CaptureContentTypeHeader.ReadOnly = new Wrapper(
    impl
  )
}
