package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TableFormat {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TableFormat
}
object TableFormat {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TableFormat
  ): zio.aws.sagemaker.model.TableFormat = value match {
    case software.amazon.awssdk.services.sagemaker.model.TableFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TableFormat.GLUE =>
      val r = Glue
      r
    case software.amazon.awssdk.services.sagemaker.model.TableFormat.ICEBERG =>
      val r = Iceberg
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.TableFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TableFormat =
      software.amazon.awssdk.services.sagemaker.model.TableFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object Glue extends zio.aws.sagemaker.model.TableFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TableFormat =
      software.amazon.awssdk.services.sagemaker.model.TableFormat.GLUE
  }
  case object Iceberg extends zio.aws.sagemaker.model.TableFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TableFormat =
      software.amazon.awssdk.services.sagemaker.model.TableFormat.ICEBERG
  }
}
