package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelVariantName
import scala.jdk.CollectionConverters.*
final case class ShadowModeConfig(
    sourceModelVariantName: ModelVariantName,
    shadowModelVariants: Iterable[
      zio.aws.sagemaker.model.ShadowModelVariantConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig = {
    import ShadowModeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig
      .builder()
      .sourceModelVariantName(
        ModelVariantName.unwrap(sourceModelVariantName): java.lang.String
      )
      .shadowModelVariants(shadowModelVariants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly =
    zio.aws.sagemaker.model.ShadowModeConfig.wrap(buildAwsValue())
}
object ShadowModeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ShadowModeConfig =
      zio.aws.sagemaker.model.ShadowModeConfig(
        sourceModelVariantName,
        shadowModelVariants.map { item =>
          item.asEditable
        }
      )
    def sourceModelVariantName: ModelVariantName
    def shadowModelVariants
        : List[zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly]
    def getSourceModelVariantName: ZIO[Any, Nothing, ModelVariantName] =
      ZIO.succeed(sourceModelVariantName)
    def getShadowModelVariants: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly
    ]] = ZIO.succeed(shadowModelVariants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig
  ) extends zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly {
    override val sourceModelVariantName: ModelVariantName =
      zio.aws.sagemaker.model.primitives
        .ModelVariantName(impl.sourceModelVariantName())
    override val shadowModelVariants
        : List[zio.aws.sagemaker.model.ShadowModelVariantConfig.ReadOnly] = impl
      .shadowModelVariants()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ShadowModelVariantConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ShadowModeConfig
  ): zio.aws.sagemaker.model.ShadowModeConfig.ReadOnly = new Wrapper(impl)
}
