package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class Parent(
    trialName: Optional[ExperimentEntityName] = Optional.Absent,
    experimentName: Optional[ExperimentEntityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Parent = {
    import Parent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Parent
      .builder()
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Parent.ReadOnly =
    zio.aws.sagemaker.model.Parent.wrap(buildAwsValue())
}
object Parent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Parent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Parent = zio.aws.sagemaker.model
      .Parent(trialName.map(value => value), experimentName.map(value => value))
    def trialName: Optional[ExperimentEntityName]
    def experimentName: Optional[ExperimentEntityName]
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Parent
  ) extends zio.aws.sagemaker.model.Parent.ReadOnly {
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val experimentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Parent
  ): zio.aws.sagemaker.model.Parent.ReadOnly = new Wrapper(impl)
}
