package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelVariantAction {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelVariantAction
}
object ModelVariantAction {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelVariantAction
  ): zio.aws.sagemaker.model.ModelVariantAction = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.RETAIN =>
      val r = Retain
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.REMOVE =>
      val r = Remove
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.PROMOTE =>
      val r = Promote
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelVariantAction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantAction =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.UNKNOWN_TO_SDK_VERSION
  }
  case object Retain extends zio.aws.sagemaker.model.ModelVariantAction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantAction =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.RETAIN
  }
  case object Remove extends zio.aws.sagemaker.model.ModelVariantAction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantAction =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.REMOVE
  }
  case object Promote extends zio.aws.sagemaker.model.ModelVariantAction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelVariantAction =
      software.amazon.awssdk.services.sagemaker.model.ModelVariantAction.PROMOTE
  }
}
