package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModelMetadataSummary(
    domain: String,
    framework: String,
    task: String,
    model: String,
    frameworkVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary = {
    import ModelMetadataSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary
      .builder()
      .domain(domain: java.lang.String)
      .framework(framework: java.lang.String)
      .task(task: java.lang.String)
      .model(model: java.lang.String)
      .frameworkVersion(frameworkVersion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelMetadataSummary.wrap(buildAwsValue())
}
object ModelMetadataSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelMetadataSummary =
      zio.aws.sagemaker.model.ModelMetadataSummary(
        domain,
        framework,
        task,
        model,
        frameworkVersion
      )
    def domain: String
    def framework: String
    def task: String
    def model: String
    def frameworkVersion: String
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getFramework: ZIO[Any, Nothing, String] = ZIO.succeed(framework)
    def getTask: ZIO[Any, Nothing, String] = ZIO.succeed(task)
    def getModel: ZIO[Any, Nothing, String] = ZIO.succeed(model)
    def getFrameworkVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(frameworkVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary
  ) extends zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly {
    override val domain: String = impl.domain(): String
    override val framework: String = impl.framework(): String
    override val task: String = impl.task(): String
    override val model: String = impl.model(): String
    override val frameworkVersion: String = impl.frameworkVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary
  ): zio.aws.sagemaker.model.ModelMetadataSummary.ReadOnly = new Wrapper(impl)
}
