package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListUserProfilesResponse(
    userProfiles: Optional[
      Iterable[zio.aws.sagemaker.model.UserProfileDetails]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse = {
    import ListUserProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse
      .builder()
      .optionallyWith(
        userProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userProfiles)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly =
    zio.aws.sagemaker.model.ListUserProfilesResponse.wrap(buildAwsValue())
}
object ListUserProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListUserProfilesResponse =
      zio.aws.sagemaker.model.ListUserProfilesResponse(
        userProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def userProfiles
        : Optional[List[zio.aws.sagemaker.model.UserProfileDetails.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getUserProfiles: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.UserProfileDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("userProfiles", userProfiles)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse
  ) extends zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly {
    override val userProfiles
        : Optional[List[zio.aws.sagemaker.model.UserProfileDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.UserProfileDetails.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse
  ): zio.aws.sagemaker.model.ListUserProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
