package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  SpaceName,
  DomainId,
  MaxResults,
  UserProfileName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAppsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.AppSortKey] = Optional.Absent,
    domainIdEquals: Optional[DomainId] = Optional.Absent,
    userProfileNameEquals: Optional[UserProfileName] = Optional.Absent,
    spaceNameEquals: Optional[SpaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAppsRequest = {
    import ListAppsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        domainIdEquals.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainIdEquals)
      .optionallyWith(
        userProfileNameEquals.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileNameEquals)
      .optionallyWith(
        spaceNameEquals.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceNameEquals)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAppsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAppsRequest.wrap(buildAwsValue())
}
object ListAppsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAppsRequest =
      zio.aws.sagemaker.model.ListAppsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        domainIdEquals.map(value => value),
        userProfileNameEquals.map(value => value),
        spaceNameEquals.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.AppSortKey]
    def domainIdEquals: Optional[DomainId]
    def userProfileNameEquals: Optional[UserProfileName]
    def spaceNameEquals: Optional[SpaceName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getDomainIdEquals: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainIdEquals", domainIdEquals)
    def getUserProfileNameEquals: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileNameEquals", userProfileNameEquals)
    def getSpaceNameEquals: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceNameEquals", spaceNameEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ) extends zio.aws.sagemaker.model.ListAppsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.AppSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.AppSortKey.wrap(value))
    override val domainIdEquals: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIdEquals())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileNameEquals: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileNameEquals())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val spaceNameEquals: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceNameEquals())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAppsRequest
  ): zio.aws.sagemaker.model.ListAppsRequest.ReadOnly = new Wrapper(impl)
}
