package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HubContentType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HubContentType
}
object HubContentType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HubContentType
  ): zio.aws.sagemaker.model.HubContentType = value match {
    case software.amazon.awssdk.services.sagemaker.model.HubContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentType.MODEL =>
      val r = Model
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentType.NOTEBOOK =>
      val r = Notebook
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HubContentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentType =
      software.amazon.awssdk.services.sagemaker.model.HubContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object Model extends zio.aws.sagemaker.model.HubContentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentType =
      software.amazon.awssdk.services.sagemaker.model.HubContentType.MODEL
  }
  case object Notebook extends zio.aws.sagemaker.model.HubContentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentType =
      software.amazon.awssdk.services.sagemaker.model.HubContentType.NOTEBOOK
  }
}
