package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Explainability(
    report: Optional[zio.aws.sagemaker.model.MetricsSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Explainability = {
    import Explainability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Explainability
      .builder()
      .optionallyWith(report.map(value => value.buildAwsValue()))(_.report)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Explainability.ReadOnly =
    zio.aws.sagemaker.model.Explainability.wrap(buildAwsValue())
}
object Explainability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Explainability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Explainability =
      zio.aws.sagemaker.model
        .Explainability(report.map(value => value.asEditable))
    def report: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getReport
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("report", report)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Explainability
  ) extends zio.aws.sagemaker.model.Explainability.ReadOnly {
    override val report
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.report())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Explainability
  ): zio.aws.sagemaker.model.Explainability.ReadOnly = new Wrapper(impl)
}
