package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLMetricEnum {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum
}
object AutoMLMetricEnum {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum
  ): zio.aws.sagemaker.model.AutoMLMetricEnum = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.ACCURACY =>
      val r = Accuracy
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MSE =>
      val r = MSE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1 =>
      val r = F1
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1_MACRO =>
      val r = F1macro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.AUC =>
      val r = AUC
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RMSE =>
      val r = RMSE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MAE =>
      val r = MAE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.R2 =>
      val r = R2
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.BALANCED_ACCURACY =>
      val r = BalancedAccuracy
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.PRECISION =>
      val r = Precision
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.PRECISION_MACRO =>
      val r = PrecisionMacro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RECALL =>
      val r = Recall
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RECALL_MACRO =>
      val r = RecallMacro
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object Accuracy extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.ACCURACY
  }
  case object MSE extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MSE
  }
  case object F1 extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1
  }
  case object F1macro extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.F1_MACRO
  }
  case object AUC extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.AUC
  }
  case object RMSE extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RMSE
  }
  case object MAE extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.MAE
  }
  case object R2 extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.R2
  }
  case object BalancedAccuracy
      extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.BALANCED_ACCURACY
  }
  case object Precision extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.PRECISION
  }
  case object PrecisionMacro extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.PRECISION_MACRO
  }
  case object Recall extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RECALL
  }
  case object RecallMacro extends zio.aws.sagemaker.model.AutoMLMetricEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricEnum.RECALL_MACRO
  }
}
