package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SpaceArn
import scala.jdk.CollectionConverters.*
final case class UpdateSpaceResponse(
    spaceArn: Optional[SpaceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse = {
    import UpdateSpaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse
      .builder()
      .optionallyWith(
        spaceArn.map(value => SpaceArn.unwrap(value): java.lang.String)
      )(_.spaceArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateSpaceResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateSpaceResponse.wrap(buildAwsValue())
}
object UpdateSpaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateSpaceResponse =
      zio.aws.sagemaker.model.UpdateSpaceResponse(spaceArn.map(value => value))
    def spaceArn: Optional[SpaceArn]
    def getSpaceArn: ZIO[Any, AwsError, SpaceArn] =
      AwsError.unwrapOptionField("spaceArn", spaceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse
  ) extends zio.aws.sagemaker.model.UpdateSpaceResponse.ReadOnly {
    override val spaceArn: Optional[SpaceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceArn())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse
  ): zio.aws.sagemaker.model.UpdateSpaceResponse.ReadOnly = new Wrapper(impl)
}
