package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MonitoringEvaluationPeriod,
  MonitoringDatapointsToAlert,
  Timestamp,
  MonitoringAlertName
}
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MonitoringAlertSummary(
    monitoringAlertName: MonitoringAlertName,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus,
    datapointsToAlert: MonitoringDatapointsToAlert,
    evaluationPeriod: MonitoringEvaluationPeriod,
    actions: zio.aws.sagemaker.model.MonitoringAlertActions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary = {
    import MonitoringAlertSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary
      .builder()
      .monitoringAlertName(
        MonitoringAlertName.unwrap(monitoringAlertName): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .alertStatus(alertStatus.unwrap)
      .datapointsToAlert(
        MonitoringDatapointsToAlert.unwrap(datapointsToAlert): Integer
      )
      .evaluationPeriod(
        MonitoringEvaluationPeriod.unwrap(evaluationPeriod): Integer
      )
      .actions(actions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly =
    zio.aws.sagemaker.model.MonitoringAlertSummary.wrap(buildAwsValue())
}
object MonitoringAlertSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringAlertSummary =
      zio.aws.sagemaker.model.MonitoringAlertSummary(
        monitoringAlertName,
        creationTime,
        lastModifiedTime,
        alertStatus,
        datapointsToAlert,
        evaluationPeriod,
        actions.asEditable
      )
    def monitoringAlertName: MonitoringAlertName
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus
    def datapointsToAlert: MonitoringDatapointsToAlert
    def evaluationPeriod: MonitoringEvaluationPeriod
    def actions: zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly
    def getMonitoringAlertName: ZIO[Any, Nothing, MonitoringAlertName] =
      ZIO.succeed(monitoringAlertName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getAlertStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.MonitoringAlertStatus] =
      ZIO.succeed(alertStatus)
    def getDatapointsToAlert: ZIO[Any, Nothing, MonitoringDatapointsToAlert] =
      ZIO.succeed(datapointsToAlert)
    def getEvaluationPeriod: ZIO[Any, Nothing, MonitoringEvaluationPeriod] =
      ZIO.succeed(evaluationPeriod)
    def getActions: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly
    ] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary
  ) extends zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly {
    override val monitoringAlertName: MonitoringAlertName =
      zio.aws.sagemaker.model.primitives
        .MonitoringAlertName(impl.monitoringAlertName())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val alertStatus: zio.aws.sagemaker.model.MonitoringAlertStatus =
      zio.aws.sagemaker.model.MonitoringAlertStatus.wrap(impl.alertStatus())
    override val datapointsToAlert: MonitoringDatapointsToAlert =
      zio.aws.sagemaker.model.primitives
        .MonitoringDatapointsToAlert(impl.datapointsToAlert())
    override val evaluationPeriod: MonitoringEvaluationPeriod =
      zio.aws.sagemaker.model.primitives
        .MonitoringEvaluationPeriod(impl.evaluationPeriod())
    override val actions
        : zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly =
      zio.aws.sagemaker.model.MonitoringAlertActions.wrap(impl.actions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary
  ): zio.aws.sagemaker.model.MonitoringAlertSummary.ReadOnly = new Wrapper(impl)
}
