package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelSortKey {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelSortKey
}
object ModelSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelSortKey
  ): zio.aws.sagemaker.model.ModelSortKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelSortKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelSortKey.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ModelSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelSortKey =
      software.amazon.awssdk.services.sagemaker.model.ModelSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.ModelSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelSortKey =
      software.amazon.awssdk.services.sagemaker.model.ModelSortKey.NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.ModelSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelSortKey =
      software.amazon.awssdk.services.sagemaker.model.ModelSortKey.CREATION_TIME
  }
}
