package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters.*
final case class ModelArtifacts(s3ModelArtifacts: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelArtifacts = {
    import ModelArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelArtifacts
      .builder()
      .s3ModelArtifacts(S3Uri.unwrap(s3ModelArtifacts): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelArtifacts.ReadOnly =
    zio.aws.sagemaker.model.ModelArtifacts.wrap(buildAwsValue())
}
object ModelArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelArtifacts =
      zio.aws.sagemaker.model.ModelArtifacts(s3ModelArtifacts)
    def s3ModelArtifacts: S3Uri
    def getS3ModelArtifacts: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(s3ModelArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelArtifacts
  ) extends zio.aws.sagemaker.model.ModelArtifacts.ReadOnly {
    override val s3ModelArtifacts: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3ModelArtifacts())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelArtifacts
  ): zio.aws.sagemaker.model.ModelArtifacts.ReadOnly = new Wrapper(impl)
}
