package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListEndpointConfigsResponse(
    endpointConfigs: Iterable[zio.aws.sagemaker.model.EndpointConfigSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse = {
    import ListEndpointConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse
      .builder()
      .endpointConfigs(endpointConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListEndpointConfigsResponse.wrap(buildAwsValue())
}
object ListEndpointConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEndpointConfigsResponse =
      zio.aws.sagemaker.model.ListEndpointConfigsResponse(
        endpointConfigs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def endpointConfigs
        : List[zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getEndpointConfigs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly
    ]] = ZIO.succeed(endpointConfigs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse
  ) extends zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly {
    override val endpointConfigs
        : List[zio.aws.sagemaker.model.EndpointConfigSummary.ReadOnly] = impl
      .endpointConfigs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.EndpointConfigSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse
  ): zio.aws.sagemaker.model.ListEndpointConfigsResponse.ReadOnly = new Wrapper(
    impl
  )
}
