package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EndpointPerformance(
    metrics: zio.aws.sagemaker.model.InferenceMetrics,
    endpointInfo: zio.aws.sagemaker.model.EndpointInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointPerformance = {
    import EndpointPerformance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointPerformance
      .builder()
      .metrics(metrics.buildAwsValue())
      .endpointInfo(endpointInfo.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointPerformance.ReadOnly =
    zio.aws.sagemaker.model.EndpointPerformance.wrap(buildAwsValue())
}
object EndpointPerformance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointPerformance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointPerformance =
      zio.aws.sagemaker.model
        .EndpointPerformance(metrics.asEditable, endpointInfo.asEditable)
    def metrics: zio.aws.sagemaker.model.InferenceMetrics.ReadOnly
    def endpointInfo: zio.aws.sagemaker.model.EndpointInfo.ReadOnly
    def getMetrics
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.InferenceMetrics.ReadOnly] =
      ZIO.succeed(metrics)
    def getEndpointInfo
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointInfo.ReadOnly] =
      ZIO.succeed(endpointInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointPerformance
  ) extends zio.aws.sagemaker.model.EndpointPerformance.ReadOnly {
    override val metrics: zio.aws.sagemaker.model.InferenceMetrics.ReadOnly =
      zio.aws.sagemaker.model.InferenceMetrics.wrap(impl.metrics())
    override val endpointInfo: zio.aws.sagemaker.model.EndpointInfo.ReadOnly =
      zio.aws.sagemaker.model.EndpointInfo.wrap(impl.endpointInfo())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointPerformance
  ): zio.aws.sagemaker.model.EndpointPerformance.ReadOnly = new Wrapper(impl)
}
