package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EdgeDeploymentConfig(
    failureHandlingPolicy: zio.aws.sagemaker.model.FailureHandlingPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig = {
    import EdgeDeploymentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig
      .builder()
      .failureHandlingPolicy(failureHandlingPolicy.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly =
    zio.aws.sagemaker.model.EdgeDeploymentConfig.wrap(buildAwsValue())
}
object EdgeDeploymentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeDeploymentConfig =
      zio.aws.sagemaker.model.EdgeDeploymentConfig(failureHandlingPolicy)
    def failureHandlingPolicy: zio.aws.sagemaker.model.FailureHandlingPolicy
    def getFailureHandlingPolicy
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.FailureHandlingPolicy] =
      ZIO.succeed(failureHandlingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig
  ) extends zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly {
    override val failureHandlingPolicy
        : zio.aws.sagemaker.model.FailureHandlingPolicy =
      zio.aws.sagemaker.model.FailureHandlingPolicy
        .wrap(impl.failureHandlingPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig
  ): zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly = new Wrapper(impl)
}
