package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MLFramework,
  ReleaseNotes,
  Timestamp,
  FailureReason,
  ImageArn,
  ImageBaseImage,
  ImageContainerImage,
  ImageVersionNumber,
  Horovod,
  ImageVersionArn,
  ProgrammingLang
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeImageVersionResponse(
    baseImage: Optional[ImageBaseImage] = Optional.Absent,
    containerImage: Optional[ImageContainerImage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    imageArn: Optional[ImageArn] = Optional.Absent,
    imageVersionArn: Optional[ImageVersionArn] = Optional.Absent,
    imageVersionStatus: Optional[zio.aws.sagemaker.model.ImageVersionStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    version: Optional[ImageVersionNumber] = Optional.Absent,
    vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance] =
      Optional.Absent,
    jobType: Optional[zio.aws.sagemaker.model.JobType] = Optional.Absent,
    mlFramework: Optional[MLFramework] = Optional.Absent,
    programmingLang: Optional[ProgrammingLang] = Optional.Absent,
    processor: Optional[zio.aws.sagemaker.model.Processor] = Optional.Absent,
    horovod: Optional[Horovod] = Optional.Absent,
    releaseNotes: Optional[ReleaseNotes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse = {
    import DescribeImageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
      .builder()
      .optionallyWith(
        baseImage.map(value => ImageBaseImage.unwrap(value): java.lang.String)
      )(_.baseImage)
      .optionallyWith(
        containerImage.map(value =>
          ImageContainerImage.unwrap(value): java.lang.String
        )
      )(_.containerImage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        imageArn.map(value => ImageArn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        imageVersionArn.map(value =>
          ImageVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageVersionArn)
      .optionallyWith(imageVersionStatus.map(value => value.unwrap))(
        _.imageVersionStatus
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(vendorGuidance.map(value => value.unwrap))(
        _.vendorGuidance
      )
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(
        mlFramework.map(value => MLFramework.unwrap(value): java.lang.String)
      )(_.mlFramework)
      .optionallyWith(
        programmingLang.map(value =>
          ProgrammingLang.unwrap(value): java.lang.String
        )
      )(_.programmingLang)
      .optionallyWith(processor.map(value => value.unwrap))(_.processor)
      .optionallyWith(
        horovod.map(value => Horovod.unwrap(value): java.lang.Boolean)
      )(_.horovod)
      .optionallyWith(
        releaseNotes.map(value => ReleaseNotes.unwrap(value): java.lang.String)
      )(_.releaseNotes)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeImageVersionResponse.wrap(buildAwsValue())
}
object DescribeImageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeImageVersionResponse =
      zio.aws.sagemaker.model.DescribeImageVersionResponse(
        baseImage.map(value => value),
        containerImage.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        imageArn.map(value => value),
        imageVersionArn.map(value => value),
        imageVersionStatus.map(value => value),
        lastModifiedTime.map(value => value),
        version.map(value => value),
        vendorGuidance.map(value => value),
        jobType.map(value => value),
        mlFramework.map(value => value),
        programmingLang.map(value => value),
        processor.map(value => value),
        horovod.map(value => value),
        releaseNotes.map(value => value)
      )
    def baseImage: Optional[ImageBaseImage]
    def containerImage: Optional[ImageContainerImage]
    def creationTime: Optional[Timestamp]
    def failureReason: Optional[FailureReason]
    def imageArn: Optional[ImageArn]
    def imageVersionArn: Optional[ImageVersionArn]
    def imageVersionStatus: Optional[zio.aws.sagemaker.model.ImageVersionStatus]
    def lastModifiedTime: Optional[Timestamp]
    def version: Optional[ImageVersionNumber]
    def vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance]
    def jobType: Optional[zio.aws.sagemaker.model.JobType]
    def mlFramework: Optional[MLFramework]
    def programmingLang: Optional[ProgrammingLang]
    def processor: Optional[zio.aws.sagemaker.model.Processor]
    def horovod: Optional[Horovod]
    def releaseNotes: Optional[ReleaseNotes]
    def getBaseImage: ZIO[Any, AwsError, ImageBaseImage] =
      AwsError.unwrapOptionField("baseImage", baseImage)
    def getContainerImage: ZIO[Any, AwsError, ImageContainerImage] =
      AwsError.unwrapOptionField("containerImage", containerImage)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImageArn: ZIO[Any, AwsError, ImageArn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getImageVersionArn: ZIO[Any, AwsError, ImageVersionArn] =
      AwsError.unwrapOptionField("imageVersionArn", imageVersionArn)
    def getImageVersionStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageVersionStatus] =
      AwsError.unwrapOptionField("imageVersionStatus", imageVersionStatus)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getVendorGuidance
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VendorGuidance] =
      AwsError.unwrapOptionField("vendorGuidance", vendorGuidance)
    def getJobType: ZIO[Any, AwsError, zio.aws.sagemaker.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getMlFramework: ZIO[Any, AwsError, MLFramework] =
      AwsError.unwrapOptionField("mlFramework", mlFramework)
    def getProgrammingLang: ZIO[Any, AwsError, ProgrammingLang] =
      AwsError.unwrapOptionField("programmingLang", programmingLang)
    def getProcessor: ZIO[Any, AwsError, zio.aws.sagemaker.model.Processor] =
      AwsError.unwrapOptionField("processor", processor)
    def getHorovod: ZIO[Any, AwsError, Horovod] =
      AwsError.unwrapOptionField("horovod", horovod)
    def getReleaseNotes: ZIO[Any, AwsError, ReleaseNotes] =
      AwsError.unwrapOptionField("releaseNotes", releaseNotes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ) extends zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly {
    override val baseImage: Optional[ImageBaseImage] = zio.aws.core.internal
      .optionalFromNullable(impl.baseImage())
      .map(value => zio.aws.sagemaker.model.primitives.ImageBaseImage(value))
    override val containerImage: Optional[ImageContainerImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerImage())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ImageContainerImage(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val imageArn: Optional[ImageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.sagemaker.model.primitives.ImageArn(value))
    override val imageVersionArn: Optional[ImageVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionArn())
        .map(value => zio.aws.sagemaker.model.primitives.ImageVersionArn(value))
    override val imageVersionStatus
        : Optional[zio.aws.sagemaker.model.ImageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionStatus())
        .map(value => zio.aws.sagemaker.model.ImageVersionStatus.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val version: Optional[ImageVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
    override val vendorGuidance
        : Optional[zio.aws.sagemaker.model.VendorGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorGuidance())
        .map(value => zio.aws.sagemaker.model.VendorGuidance.wrap(value))
    override val jobType: Optional[zio.aws.sagemaker.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.sagemaker.model.JobType.wrap(value))
    override val mlFramework: Optional[MLFramework] = zio.aws.core.internal
      .optionalFromNullable(impl.mlFramework())
      .map(value => zio.aws.sagemaker.model.primitives.MLFramework(value))
    override val programmingLang: Optional[ProgrammingLang] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programmingLang())
        .map(value => zio.aws.sagemaker.model.primitives.ProgrammingLang(value))
    override val processor: Optional[zio.aws.sagemaker.model.Processor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processor())
        .map(value => zio.aws.sagemaker.model.Processor.wrap(value))
    override val horovod: Optional[Horovod] = zio.aws.core.internal
      .optionalFromNullable(impl.horovod())
      .map(value => zio.aws.sagemaker.model.primitives.Horovod(value))
    override val releaseNotes: Optional[ReleaseNotes] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseNotes())
      .map(value => zio.aws.sagemaker.model.primitives.ReleaseNotes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse
  ): zio.aws.sagemaker.model.DescribeImageVersionResponse.ReadOnly =
    new Wrapper(impl)
}
