package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AutoMLAlgorithmConfig(
    autoMLAlgorithms: Iterable[zio.aws.sagemaker.model.AutoMLAlgorithm]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig = {
    import AutoMLAlgorithmConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig
      .builder()
      .autoMLAlgorithmsWithStrings(autoMLAlgorithms.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLAlgorithmConfig.wrap(buildAwsValue())
}
object AutoMLAlgorithmConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLAlgorithmConfig =
      zio.aws.sagemaker.model.AutoMLAlgorithmConfig(autoMLAlgorithms)
    def autoMLAlgorithms: List[zio.aws.sagemaker.model.AutoMLAlgorithm]
    def getAutoMLAlgorithms
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.AutoMLAlgorithm]] =
      ZIO.succeed(autoMLAlgorithms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig
  ) extends zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly {
    override val autoMLAlgorithms
        : List[zio.aws.sagemaker.model.AutoMLAlgorithm] = impl
      .autoMLAlgorithms()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLAlgorithm.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLAlgorithmConfig
  ): zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly = new Wrapper(impl)
}
