package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWorkforceResponse(
    workforce: zio.aws.sagemaker.model.Workforce
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse = {
    import UpdateWorkforceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse
      .builder()
      .workforce(workforce.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateWorkforceResponse.wrap(buildAwsValue())
}
object UpdateWorkforceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateWorkforceResponse =
      zio.aws.sagemaker.model.UpdateWorkforceResponse(workforce.asEditable)
    def workforce: zio.aws.sagemaker.model.Workforce.ReadOnly
    def getWorkforce
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.Workforce.ReadOnly] =
      ZIO.succeed(workforce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse
  ) extends zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly {
    override val workforce: zio.aws.sagemaker.model.Workforce.ReadOnly =
      zio.aws.sagemaker.model.Workforce.wrap(impl.workforce())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse
  ): zio.aws.sagemaker.model.UpdateWorkforceResponse.ReadOnly = new Wrapper(
    impl
  )
}
