package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EntityDescription, ProjectEntityName}
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    projectName: ProjectEntityName,
    projectDescription: Optional[EntityDescription] = Optional.Absent,
    serviceCatalogProvisioningUpdateDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest
      .builder()
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .optionallyWith(
        serviceCatalogProvisioningUpdateDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.serviceCatalogProvisioningUpdateDetails)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateProjectRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateProjectRequest =
      zio.aws.sagemaker.model.UpdateProjectRequest(
        projectName,
        projectDescription.map(value => value),
        serviceCatalogProvisioningUpdateDetails.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def projectName: ProjectEntityName
    def projectDescription: Optional[EntityDescription]
    def serviceCatalogProvisioningUpdateDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly
    ]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getServiceCatalogProvisioningUpdateDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisioningUpdateDetails",
      serviceCatalogProvisioningUpdateDetails
    )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest
  ) extends zio.aws.sagemaker.model.UpdateProjectRequest.ReadOnly {
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
    override val projectDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val serviceCatalogProvisioningUpdateDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCatalogProvisioningUpdateDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisioningUpdateDetails
          .wrap(value)
      )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest
  ): zio.aws.sagemaker.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
