package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrainingJobSortByOptions {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions
}
object TrainingJobSortByOptions {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions
  ): zio.aws.sagemaker.model.TrainingJobSortByOptions = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.FINAL_OBJECTIVE_METRIC_VALUE =>
      val r = FinalObjectiveMetricValue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrainingJobSortByOptions {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.TrainingJobSortByOptions {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.NAME
  }
  case object CreationTime
      extends zio.aws.sagemaker.model.TrainingJobSortByOptions {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.TrainingJobSortByOptions {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.STATUS
  }
  case object FinalObjectiveMetricValue
      extends zio.aws.sagemaker.model.TrainingJobSortByOptions {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobSortByOptions.FINAL_OBJECTIVE_METRIC_VALUE
  }
}
