package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class StopEdgePackagingJobRequest(edgePackagingJobName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest = {
    import StopEdgePackagingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest
      .builder()
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopEdgePackagingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopEdgePackagingJobRequest.wrap(buildAwsValue())
}
object StopEdgePackagingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopEdgePackagingJobRequest =
      zio.aws.sagemaker.model.StopEdgePackagingJobRequest(edgePackagingJobName)
    def edgePackagingJobName: EntityName
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest
  ) extends zio.aws.sagemaker.model.StopEdgePackagingJobRequest.ReadOnly {
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest
  ): zio.aws.sagemaker.model.StopEdgePackagingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
