package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Cidr
import scala.jdk.CollectionConverters.*
final case class SourceIpConfig(cidrs: Iterable[Cidr]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SourceIpConfig = {
    import SourceIpConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SourceIpConfig
      .builder()
      .cidrs(cidrs.map { item =>
        Cidr.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SourceIpConfig.ReadOnly =
    zio.aws.sagemaker.model.SourceIpConfig.wrap(buildAwsValue())
}
object SourceIpConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SourceIpConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SourceIpConfig =
      zio.aws.sagemaker.model.SourceIpConfig(cidrs)
    def cidrs: List[Cidr]
    def getCidrs: ZIO[Any, Nothing, List[Cidr]] = ZIO.succeed(cidrs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceIpConfig
  ) extends zio.aws.sagemaker.model.SourceIpConfig.ReadOnly {
    override val cidrs: List[Cidr] = impl
      .cidrs()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.Cidr(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceIpConfig
  ): zio.aws.sagemaker.model.SourceIpConfig.ReadOnly = new Wrapper(impl)
}
