package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait RedshiftResultFormat {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat
}
object RedshiftResultFormat {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat
  ): zio.aws.sagemaker.model.RedshiftResultFormat = value match {
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.PARQUET =>
      val r = PARQUET
      r
    case software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RedshiftResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object PARQUET extends zio.aws.sagemaker.model.RedshiftResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.PARQUET
  }
  case object CSV extends zio.aws.sagemaker.model.RedshiftResultFormat {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat =
      software.amazon.awssdk.services.sagemaker.model.RedshiftResultFormat.CSV
  }
}
