package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ProjectEntityName,
  ProjectId,
  Timestamp,
  ProjectArn,
  EntityDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Project(
    projectArn: Optional[ProjectArn] = Optional.Absent,
    projectName: Optional[ProjectEntityName] = Optional.Absent,
    projectId: Optional[ProjectId] = Optional.Absent,
    projectDescription: Optional[EntityDescription] = Optional.Absent,
    serviceCatalogProvisioningDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails
    ] = Optional.Absent,
    serviceCatalogProvisionedProductDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
    ] = Optional.Absent,
    projectStatus: Optional[zio.aws.sagemaker.model.ProjectStatus] =
      Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Project
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .optionallyWith(
        projectName.map(value =>
          ProjectEntityName.unwrap(value): java.lang.String
        )
      )(_.projectName)
      .optionallyWith(
        projectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.projectId)
      .optionallyWith(
        projectDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .optionallyWith(
        serviceCatalogProvisioningDetails.map(value => value.buildAwsValue())
      )(_.serviceCatalogProvisioningDetails)
      .optionallyWith(
        serviceCatalogProvisionedProductDetails.map(value =>
          value.buildAwsValue()
        )
      )(_.serviceCatalogProvisionedProductDetails)
      .optionallyWith(projectStatus.map(value => value.unwrap))(_.projectStatus)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Project.ReadOnly =
    zio.aws.sagemaker.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Project] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Project =
      zio.aws.sagemaker.model.Project(
        projectArn.map(value => value),
        projectName.map(value => value),
        projectId.map(value => value),
        projectDescription.map(value => value),
        serviceCatalogProvisioningDetails.map(value => value.asEditable),
        serviceCatalogProvisionedProductDetails.map(value => value.asEditable),
        projectStatus.map(value => value),
        createdBy.map(value => value.asEditable),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable)
      )
    def projectArn: Optional[ProjectArn]
    def projectName: Optional[ProjectEntityName]
    def projectId: Optional[ProjectId]
    def projectDescription: Optional[EntityDescription]
    def serviceCatalogProvisioningDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ]
    def serviceCatalogProvisionedProductDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ]
    def projectStatus: Optional[zio.aws.sagemaker.model.ProjectStatus]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def creationTime: Optional[Timestamp]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
    def getProjectName: ZIO[Any, AwsError, ProjectEntityName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("projectId", projectId)
    def getProjectDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getServiceCatalogProvisioningDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisioningDetails",
      serviceCatalogProvisioningDetails
    )
    def getServiceCatalogProvisionedProductDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceCatalogProvisionedProductDetails",
      serviceCatalogProvisionedProductDetails
    )
    def getProjectStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProjectStatus] =
      AwsError.unwrapOptionField("projectStatus", projectStatus)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Project
  ) extends zio.aws.sagemaker.model.Project.ReadOnly {
    override val projectArn: Optional[ProjectArn] = zio.aws.core.internal
      .optionalFromNullable(impl.projectArn())
      .map(value => zio.aws.sagemaker.model.primitives.ProjectArn(value))
    override val projectName: Optional[ProjectEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ProjectEntityName(value)
        )
    override val projectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.projectId())
      .map(value => zio.aws.sagemaker.model.primitives.ProjectId(value))
    override val projectDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val serviceCatalogProvisioningDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCatalogProvisioningDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisioningDetails.wrap(value)
      )
    override val serviceCatalogProvisionedProductDetails: Optional[
      zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceCatalogProvisionedProductDetails())
      .map(value =>
        zio.aws.sagemaker.model.ServiceCatalogProvisionedProductDetails
          .wrap(value)
      )
    override val projectStatus
        : Optional[zio.aws.sagemaker.model.ProjectStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectStatus())
        .map(value => zio.aws.sagemaker.model.ProjectStatus.wrap(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Project
  ): zio.aws.sagemaker.model.Project.ReadOnly = new Wrapper(impl)
}
