package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitoringAlertActions(
    modelDashboardIndicator: Optional[
      zio.aws.sagemaker.model.ModelDashboardIndicatorAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions = {
    import MonitoringAlertActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions
      .builder()
      .optionallyWith(
        modelDashboardIndicator.map(value => value.buildAwsValue())
      )(_.modelDashboardIndicator)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly =
    zio.aws.sagemaker.model.MonitoringAlertActions.wrap(buildAwsValue())
}
object MonitoringAlertActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringAlertActions =
      zio.aws.sagemaker.model.MonitoringAlertActions(
        modelDashboardIndicator.map(value => value.asEditable)
      )
    def modelDashboardIndicator: Optional[
      zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly
    ]
    def getModelDashboardIndicator: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelDashboardIndicator",
      modelDashboardIndicator
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions
  ) extends zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly {
    override val modelDashboardIndicator: Optional[
      zio.aws.sagemaker.model.ModelDashboardIndicatorAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelDashboardIndicator())
      .map(value =>
        zio.aws.sagemaker.model.ModelDashboardIndicatorAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertActions
  ): zio.aws.sagemaker.model.MonitoringAlertActions.ReadOnly = new Wrapper(impl)
}
