package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelPackageStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus
}
object ModelPackageStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus
  ): zio.aws.sagemaker.model.ModelPackageStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.PENDING
  }
  case object InProgress extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.ModelPackageStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageStatus.DELETING
  }
}
