package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListStudioLifecycleConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    studioLifecycleConfigs: Optional[
      Iterable[zio.aws.sagemaker.model.StudioLifecycleConfigDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse = {
    import ListStudioLifecycleConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        studioLifecycleConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studioLifecycleConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse
      .wrap(buildAwsValue())
}
object ListStudioLifecycleConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse =
      zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse(
        nextToken.map(value => value),
        studioLifecycleConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def studioLifecycleConfigs: Optional[
      List[zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudioLifecycleConfigs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "studioLifecycleConfigs",
      studioLifecycleConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse
  ) extends zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val studioLifecycleConfigs: Optional[
      List[zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.studioLifecycleConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.StudioLifecycleConfigDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse
  ): zio.aws.sagemaker.model.ListStudioLifecycleConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
