package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  JobReferenceCodeContains,
  WorkteamArn,
  Timestamp,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLabelingJobsForWorkteamRequest(
    workteamArn: WorkteamArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    jobReferenceCodeContains: Optional[JobReferenceCodeContains] =
      Optional.Absent,
    sortBy: Optional[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest = {
    import ListLabelingJobsForWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
      .builder()
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        jobReferenceCodeContains.map(value =>
          JobReferenceCodeContains.unwrap(value): java.lang.String
        )
      )(_.jobReferenceCodeContains)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest
      .wrap(buildAwsValue())
}
object ListLabelingJobsForWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest =
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest(
        workteamArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        jobReferenceCodeContains.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def workteamArn: WorkteamArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def jobReferenceCodeContains: Optional[JobReferenceCodeContains]
    def sortBy: Optional[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getJobReferenceCodeContains
        : ZIO[Any, AwsError, JobReferenceCodeContains] = AwsError
      .unwrapOptionField("jobReferenceCodeContains", jobReferenceCodeContains)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ) extends zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly {
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val jobReferenceCodeContains: Optional[JobReferenceCodeContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobReferenceCodeContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.JobReferenceCodeContains(value)
        )
    override val sortBy: Optional[
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.ListLabelingJobsForWorkteamSortByOptions
          .wrap(value)
      )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest
  ): zio.aws.sagemaker.model.ListLabelingJobsForWorkteamRequest.ReadOnly =
    new Wrapper(impl)
}
