package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InferenceRecommendation(
    metrics: zio.aws.sagemaker.model.RecommendationMetrics,
    endpointConfiguration: zio.aws.sagemaker.model.EndpointOutputConfiguration,
    modelConfiguration: zio.aws.sagemaker.model.ModelConfiguration,
    recommendationId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation = {
    import InferenceRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation
      .builder()
      .metrics(metrics.buildAwsValue())
      .endpointConfiguration(endpointConfiguration.buildAwsValue())
      .modelConfiguration(modelConfiguration.buildAwsValue())
      .optionallyWith(recommendationId.map(value => value: java.lang.String))(
        _.recommendationId
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly =
    zio.aws.sagemaker.model.InferenceRecommendation.wrap(buildAwsValue())
}
object InferenceRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InferenceRecommendation =
      zio.aws.sagemaker.model.InferenceRecommendation(
        metrics.asEditable,
        endpointConfiguration.asEditable,
        modelConfiguration.asEditable,
        recommendationId.map(value => value)
      )
    def metrics: zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly
    def endpointConfiguration
        : zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly
    def modelConfiguration: zio.aws.sagemaker.model.ModelConfiguration.ReadOnly
    def recommendationId: Optional[String]
    def getMetrics: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly
    ] = ZIO.succeed(metrics)
    def getEndpointConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly
    ] = ZIO.succeed(endpointConfiguration)
    def getModelConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelConfiguration.ReadOnly
    ] = ZIO.succeed(modelConfiguration)
    def getRecommendationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation
  ) extends zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly {
    override val metrics
        : zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly =
      zio.aws.sagemaker.model.RecommendationMetrics.wrap(impl.metrics())
    override val endpointConfiguration
        : zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly =
      zio.aws.sagemaker.model.EndpointOutputConfiguration
        .wrap(impl.endpointConfiguration())
    override val modelConfiguration
        : zio.aws.sagemaker.model.ModelConfiguration.ReadOnly =
      zio.aws.sagemaker.model.ModelConfiguration.wrap(impl.modelConfiguration())
    override val recommendationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendationId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InferenceRecommendation
  ): zio.aws.sagemaker.model.InferenceRecommendation.ReadOnly = new Wrapper(
    impl
  )
}
