package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.LineageGroupNameOrArn
import scala.jdk.CollectionConverters.*
final case class GetLineageGroupPolicyRequest(
    lineageGroupName: LineageGroupNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest = {
    import GetLineageGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest
      .builder()
      .lineageGroupName(
        LineageGroupNameOrArn.unwrap(lineageGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetLineageGroupPolicyRequest.ReadOnly =
    zio.aws.sagemaker.model.GetLineageGroupPolicyRequest.wrap(buildAwsValue())
}
object GetLineageGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetLineageGroupPolicyRequest =
      zio.aws.sagemaker.model.GetLineageGroupPolicyRequest(lineageGroupName)
    def lineageGroupName: LineageGroupNameOrArn
    def getLineageGroupName: ZIO[Any, Nothing, LineageGroupNameOrArn] =
      ZIO.succeed(lineageGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest
  ) extends zio.aws.sagemaker.model.GetLineageGroupPolicyRequest.ReadOnly {
    override val lineageGroupName: LineageGroupNameOrArn =
      zio.aws.sagemaker.model.primitives
        .LineageGroupNameOrArn(impl.lineageGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest
  ): zio.aws.sagemaker.model.GetLineageGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
