package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceDeploymentStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus
}
object DeviceDeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus
  ): zio.aws.sagemaker.model.DeviceDeploymentStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.READYTODEPLOY =>
      val r = READYTODEPLOY
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.DEPLOYED =>
      val r = DEPLOYED
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READYTODEPLOY
      extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.READYTODEPLOY
  }
  case object INPROGRESS
      extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.INPROGRESS
  }
  case object DEPLOYED extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.DEPLOYED
  }
  case object FAILED extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.FAILED
  }
  case object STOPPING extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.STOPPING
  }
  case object STOPPED extends zio.aws.sagemaker.model.DeviceDeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus =
      software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentStatus.STOPPED
  }
}
