package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TransformJobName
import scala.jdk.CollectionConverters.*
final case class DescribeTransformJobRequest(
    transformJobName: TransformJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest = {
    import DescribeTransformJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest
      .builder()
      .transformJobName(
        TransformJobName.unwrap(transformJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeTransformJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeTransformJobRequest.wrap(buildAwsValue())
}
object DescribeTransformJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTransformJobRequest =
      zio.aws.sagemaker.model.DescribeTransformJobRequest(transformJobName)
    def transformJobName: TransformJobName
    def getTransformJobName: ZIO[Any, Nothing, TransformJobName] =
      ZIO.succeed(transformJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest
  ) extends zio.aws.sagemaker.model.DescribeTransformJobRequest.ReadOnly {
    override val transformJobName: TransformJobName =
      zio.aws.sagemaker.model.primitives
        .TransformJobName(impl.transformJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest
  ): zio.aws.sagemaker.model.DescribeTransformJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
