package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelCardExportJobArn
import scala.jdk.CollectionConverters.*
final case class DescribeModelCardExportJobRequest(
    modelCardExportJobArn: ModelCardExportJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest = {
    import DescribeModelCardExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest
      .builder()
      .modelCardExportJobArn(
        ModelCardExportJobArn.unwrap(modelCardExportJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelCardExportJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelCardExportJobRequest
      .wrap(buildAwsValue())
}
object DescribeModelCardExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelCardExportJobRequest =
      zio.aws.sagemaker.model
        .DescribeModelCardExportJobRequest(modelCardExportJobArn)
    def modelCardExportJobArn: ModelCardExportJobArn
    def getModelCardExportJobArn: ZIO[Any, Nothing, ModelCardExportJobArn] =
      ZIO.succeed(modelCardExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest
  ) extends zio.aws.sagemaker.model.DescribeModelCardExportJobRequest.ReadOnly {
    override val modelCardExportJobArn: ModelCardExportJobArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardExportJobArn(impl.modelCardExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest
  ): zio.aws.sagemaker.model.DescribeModelCardExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
