package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AppImageConfigName
import scala.jdk.CollectionConverters.*
final case class DeleteAppImageConfigRequest(
    appImageConfigName: AppImageConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest = {
    import DeleteAppImageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest
      .builder()
      .appImageConfigName(
        AppImageConfigName.unwrap(appImageConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteAppImageConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteAppImageConfigRequest.wrap(buildAwsValue())
}
object DeleteAppImageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteAppImageConfigRequest =
      zio.aws.sagemaker.model.DeleteAppImageConfigRequest(appImageConfigName)
    def appImageConfigName: AppImageConfigName
    def getAppImageConfigName: ZIO[Any, Nothing, AppImageConfigName] =
      ZIO.succeed(appImageConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest
  ) extends zio.aws.sagemaker.model.DeleteAppImageConfigRequest.ReadOnly {
    override val appImageConfigName: AppImageConfigName =
      zio.aws.sagemaker.model.primitives
        .AppImageConfigName(impl.appImageConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest
  ): zio.aws.sagemaker.model.DeleteAppImageConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
