package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ModelCardContent, EntityName}
import scala.jdk.CollectionConverters.*
final case class CreateModelCardRequest(
    modelCardName: EntityName,
    securityConfig: Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig] =
      Optional.Absent,
    content: ModelCardContent,
    modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest = {
    import CreateModelCardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest
      .builder()
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .content(ModelCardContent.unwrap(content): java.lang.String)
      .modelCardStatus(modelCardStatus.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateModelCardRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelCardRequest.wrap(buildAwsValue())
}
object CreateModelCardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelCardRequest =
      zio.aws.sagemaker.model.CreateModelCardRequest(
        modelCardName,
        securityConfig.map(value => value.asEditable),
        content,
        modelCardStatus,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelCardName: EntityName
    def securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly]
    def content: ModelCardContent
    def modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getContent: ZIO[Any, Nothing, ModelCardContent] = ZIO.succeed(content)
    def getModelCardStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelCardStatus] =
      ZIO.succeed(modelCardStatus)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest
  ) extends zio.aws.sagemaker.model.CreateModelCardRequest.ReadOnly {
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.ModelCardSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardSecurityConfig.wrap(value)
        )
    override val content: ModelCardContent =
      zio.aws.sagemaker.model.primitives.ModelCardContent(impl.content())
    override val modelCardStatus: zio.aws.sagemaker.model.ModelCardStatus =
      zio.aws.sagemaker.model.ModelCardStatus.wrap(impl.modelCardStatus())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest
  ): zio.aws.sagemaker.model.CreateModelCardRequest.ReadOnly = new Wrapper(impl)
}
