package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointConfigArn
import scala.jdk.CollectionConverters.*
final case class CreateEndpointConfigResponse(
    endpointConfigArn: EndpointConfigArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse = {
    import CreateEndpointConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse
      .builder()
      .endpointConfigArn(
        EndpointConfigArn.unwrap(endpointConfigArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateEndpointConfigResponse.wrap(buildAwsValue())
}
object CreateEndpointConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEndpointConfigResponse =
      zio.aws.sagemaker.model.CreateEndpointConfigResponse(endpointConfigArn)
    def endpointConfigArn: EndpointConfigArn
    def getEndpointConfigArn: ZIO[Any, Nothing, EndpointConfigArn] =
      ZIO.succeed(endpointConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse
  ) extends zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly {
    override val endpointConfigArn: EndpointConfigArn =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigArn(impl.endpointConfigArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse
  ): zio.aws.sagemaker.model.CreateEndpointConfigResponse.ReadOnly =
    new Wrapper(impl)
}
