package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ClarifyTextConfig(
    language: zio.aws.sagemaker.model.ClarifyTextLanguage,
    granularity: zio.aws.sagemaker.model.ClarifyTextGranularity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig = {
    import ClarifyTextConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig
      .builder()
      .language(language.unwrap)
      .granularity(granularity.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly =
    zio.aws.sagemaker.model.ClarifyTextConfig.wrap(buildAwsValue())
}
object ClarifyTextConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyTextConfig =
      zio.aws.sagemaker.model.ClarifyTextConfig(language, granularity)
    def language: zio.aws.sagemaker.model.ClarifyTextLanguage
    def granularity: zio.aws.sagemaker.model.ClarifyTextGranularity
    def getLanguage
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ClarifyTextLanguage] =
      ZIO.succeed(language)
    def getGranularity
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ClarifyTextGranularity] =
      ZIO.succeed(granularity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig
  ) extends zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly {
    override val language: zio.aws.sagemaker.model.ClarifyTextLanguage =
      zio.aws.sagemaker.model.ClarifyTextLanguage.wrap(impl.language())
    override val granularity: zio.aws.sagemaker.model.ClarifyTextGranularity =
      zio.aws.sagemaker.model.ClarifyTextGranularity.wrap(impl.granularity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyTextConfig
  ): zio.aws.sagemaker.model.ClarifyTextConfig.ReadOnly = new Wrapper(impl)
}
