package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class AlgorithmStatusItem(
    name: EntityName,
    status: zio.aws.sagemaker.model.DetailedAlgorithmStatus,
    failureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem = {
    import AlgorithmStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmStatusItem.wrap(buildAwsValue())
}
object AlgorithmStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmStatusItem =
      zio.aws.sagemaker.model
        .AlgorithmStatusItem(name, status, failureReason.map(value => value))
    def name: EntityName
    def status: zio.aws.sagemaker.model.DetailedAlgorithmStatus
    def failureReason: Optional[String]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.DetailedAlgorithmStatus] =
      ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem
  ) extends zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly {
    override val name: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.name())
    override val status: zio.aws.sagemaker.model.DetailedAlgorithmStatus =
      zio.aws.sagemaker.model.DetailedAlgorithmStatus.wrap(impl.status())
    override val failureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusItem
  ): zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly = new Wrapper(impl)
}
