package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineExecutionResponse(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse = {
    import UpdatePipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdatePipelineExecutionResponse
      .wrap(buildAwsValue())
}
object UpdatePipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdatePipelineExecutionResponse =
      zio.aws.sagemaker.model.UpdatePipelineExecutionResponse(
        pipelineExecutionArn.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse
  ) extends zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse
  ): zio.aws.sagemaker.model.UpdatePipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
