package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RecommendationJobName
import scala.jdk.CollectionConverters.*
final case class StopInferenceRecommendationsJobRequest(
    jobName: RecommendationJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest = {
    import StopInferenceRecommendationsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest
      .wrap(buildAwsValue())
}
object StopInferenceRecommendationsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest =
      zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest(jobName)
    def jobName: RecommendationJobName
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest
  ) extends zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest
  ): zio.aws.sagemaker.model.StopInferenceRecommendationsJobRequest.ReadOnly =
    new Wrapper(impl)
}
