package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait SpaceStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SpaceStatus
}
object SpaceStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SpaceStatus
  ): zio.aws.sagemaker.model.SpaceStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UPDATE_FAILED =>
      val r = Update_Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceStatus.DELETE_FAILED =>
      val r = Delete_Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Deleting extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.FAILED
  }
  case object InService extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.IN_SERVICE
  }
  case object Pending extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.PENDING
  }
  case object Updating extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UPDATING
  }
  case object Update_Failed extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.UPDATE_FAILED
  }
  case object Delete_Failed extends zio.aws.sagemaker.model.SpaceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceStatus =
      software.amazon.awssdk.services.sagemaker.model.SpaceStatus.DELETE_FAILED
  }
}
