package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait SpaceSortKey {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SpaceSortKey
}
object SpaceSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SpaceSortKey
  ): zio.aws.sagemaker.model.SpaceSortKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.LAST_MODIFIED_TIME =>
      val r = LastModifiedTime
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.SpaceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceSortKey =
      software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object CreationTime extends zio.aws.sagemaker.model.SpaceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceSortKey =
      software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.CREATION_TIME
  }
  case object LastModifiedTime extends zio.aws.sagemaker.model.SpaceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SpaceSortKey =
      software.amazon.awssdk.services.sagemaker.model.SpaceSortKey.LAST_MODIFIED_TIME
  }
}
