package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait RuleEvaluationStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus
}
object RuleEvaluationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus
  ): zio.aws.sagemaker.model.RuleEvaluationStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.NO_ISSUES_FOUND =>
      val r = NoIssuesFound
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.ISSUES_FOUND =>
      val r = IssuesFound
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.ERROR =>
      val r = Error
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.IN_PROGRESS
  }
  case object NoIssuesFound
      extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.NO_ISSUES_FOUND
  }
  case object IssuesFound extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.ISSUES_FOUND
  }
  case object Error extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.ERROR
  }
  case object Stopping extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.RuleEvaluationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus =
      software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus.STOPPED
  }
}
