package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters.*
final case class RecommendationJobCompiledOutputConfig(
    s3OutputUri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig = {
    import RecommendationJobCompiledOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig
      .builder()
      .optionallyWith(
        s3OutputUri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3OutputUri)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig
      .wrap(buildAwsValue())
}
object RecommendationJobCompiledOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig =
      zio.aws.sagemaker.model
        .RecommendationJobCompiledOutputConfig(s3OutputUri.map(value => value))
    def s3OutputUri: Optional[S3Uri]
    def getS3OutputUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3OutputUri", s3OutputUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly {
    override val s3OutputUri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputUri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobCompiledOutputConfig
  ): zio.aws.sagemaker.model.RecommendationJobCompiledOutputConfig.ReadOnly =
    new Wrapper(impl)
}
