package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ProfilingIntervalInMilliseconds,
  ConfigValue,
  S3Uri,
  DisableProfiler,
  ConfigKey
}
import scala.jdk.CollectionConverters.*
final case class ProfilerConfig(
    s3OutputPath: Optional[S3Uri] = Optional.Absent,
    profilingIntervalInMilliseconds: Optional[ProfilingIntervalInMilliseconds] =
      Optional.Absent,
    profilingParameters: Optional[Map[ConfigKey, ConfigValue]] =
      Optional.Absent,
    disableProfiler: Optional[DisableProfiler] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProfilerConfig = {
    import ProfilerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
      .builder()
      .optionallyWith(
        s3OutputPath.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3OutputPath)
      .optionallyWith(
        profilingIntervalInMilliseconds.map(value =>
          ProfilingIntervalInMilliseconds.unwrap(value): java.lang.Long
        )
      )(_.profilingIntervalInMilliseconds)
      .optionallyWith(
        profilingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.profilingParameters)
      .optionallyWith(
        disableProfiler.map(value =>
          DisableProfiler.unwrap(value): java.lang.Boolean
        )
      )(_.disableProfiler)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProfilerConfig.ReadOnly =
    zio.aws.sagemaker.model.ProfilerConfig.wrap(buildAwsValue())
}
object ProfilerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProfilerConfig =
      zio.aws.sagemaker.model.ProfilerConfig(
        s3OutputPath.map(value => value),
        profilingIntervalInMilliseconds.map(value => value),
        profilingParameters.map(value => value),
        disableProfiler.map(value => value)
      )
    def s3OutputPath: Optional[S3Uri]
    def profilingIntervalInMilliseconds
        : Optional[ProfilingIntervalInMilliseconds]
    def profilingParameters: Optional[Map[ConfigKey, ConfigValue]]
    def disableProfiler: Optional[DisableProfiler]
    def getS3OutputPath: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
    def getProfilingIntervalInMilliseconds
        : ZIO[Any, AwsError, ProfilingIntervalInMilliseconds] =
      AwsError.unwrapOptionField(
        "profilingIntervalInMilliseconds",
        profilingIntervalInMilliseconds
      )
    def getProfilingParameters
        : ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("profilingParameters", profilingParameters)
    def getDisableProfiler: ZIO[Any, AwsError, DisableProfiler] =
      AwsError.unwrapOptionField("disableProfiler", disableProfiler)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ) extends zio.aws.sagemaker.model.ProfilerConfig.ReadOnly {
    override val s3OutputPath: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val profilingIntervalInMilliseconds
        : Optional[ProfilingIntervalInMilliseconds] = zio.aws.core.internal
      .optionalFromNullable(impl.profilingIntervalInMilliseconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .ProfilingIntervalInMilliseconds(value)
      )
    override val profilingParameters: Optional[Map[ConfigKey, ConfigValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilingParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ConfigKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
            })
            .toMap
        )
    override val disableProfiler: Optional[DisableProfiler] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableProfiler())
        .map(value => zio.aws.sagemaker.model.primitives.DisableProfiler(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProfilerConfig
  ): zio.aws.sagemaker.model.ProfilerConfig.ReadOnly = new Wrapper(impl)
}
