package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NotificationTopicArn
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    notificationTopicArn: Optional[NotificationTopicArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration
      .builder()
      .optionallyWith(
        notificationTopicArn.map(value =>
          NotificationTopicArn.unwrap(value): java.lang.String
        )
      )(_.notificationTopicArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly =
    zio.aws.sagemaker.model.NotificationConfiguration.wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NotificationConfiguration =
      zio.aws.sagemaker.model
        .NotificationConfiguration(notificationTopicArn.map(value => value))
    def notificationTopicArn: Optional[NotificationTopicArn]
    def getNotificationTopicArn: ZIO[Any, AwsError, NotificationTopicArn] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration
  ) extends zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly {
    override val notificationTopicArn: Optional[NotificationTopicArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTopicArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NotificationTopicArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NotificationConfiguration
  ): zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
