package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDomainsResponse(
    domains: Optional[Iterable[zio.aws.sagemaker.model.DomainDetails]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse = {
    import ListDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse
      .builder()
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListDomainsResponse.wrap(buildAwsValue())
}
object ListDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListDomainsResponse =
      zio.aws.sagemaker.model.ListDomainsResponse(
        domains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def domains: Optional[List[zio.aws.sagemaker.model.DomainDetails.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDomains: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DomainDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("domains", domains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse
  ) extends zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly {
    override val domains
        : Optional[List[zio.aws.sagemaker.model.DomainDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.DomainDetails.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse
  ): zio.aws.sagemaker.model.ListDomainsResponse.ReadOnly = new Wrapper(impl)
}
